% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel_cent.R
\name{ds_rel_cent}
\alias{ds_rel_cent}
\alias{rel_cent}
\title{Compute Relative Centralization}
\usage{
ds_rel_cent(.data, .cols, .name)

rel_cent(..., .data = dplyr::across(everything()))
}
\arguments{
\item{.data}{\link[tibble:tibble-package]{tibble} with sf geometry}

\item{.cols}{\href{https://tidyselect.r-lib.org/reference/language.html}{\code{tidy-select}}
Columns to compute the measure with. Must be at least 2 columns. If more than 2, treats
first column as first group and sum of other columns as second.}

\item{.name}{name for column with relative centralization. Leave missing to return a vector.}

\item{...}{arguments to forward to ds_rel_cent from rel_cent}
}
\value{
a \link[tibble:tibble-package]{tibble} or numeric vector if .name missing
}
\description{
Compute Relative Centralization
}
\examples{
data('de_county')
ds_rel_cent(de_county, c(pop_white, starts_with('pop_')))
ds_rel_cent(de_county, c(pop_white, starts_with('pop_')), 'rel_cent')
}
\concept{centralization}
