% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dists-categorical.R
\name{summary.dodgr_dists_categorical}
\alias{summary.dodgr_dists_categorical}
\title{Transform a result from \link{dodgr_dists_categorical} to summary statistics}
\usage{
\method{summary}{dodgr_dists_categorical}(object, ...)
}
\arguments{
\item{object}{A 'dodgr_dists_categorical' object}

\item{...}{Extra parameters currently not used}
}
\value{
The summary statistics (invisibly)
}
\description{
Transform a result from \link{dodgr_dists_categorical} to summary statistics
}
\examples{
# Prepare a graph for categorical routing by including an "edge_type" column
graph <- weight_streetnet (hampi, wt_profile = "foot")
graph <- graph [graph$component == 1, ]
graph$edge_type <- graph$highway
# Define start and end points for categorical distances; using all vertices
# here.
length (unique (graph$edge_type)) # Number of categories
v <- dodgr_vertices (graph)
from <- to <- v$id [1:100]
d <- dodgr_dists_categorical (graph, from, to)
# Internal 'summary' method to summarise results:
summary (d)

}
\seealso{
Other misc: 
\code{\link{compare_heaps}()},
\code{\link{dodgr_flowmap}()},
\code{\link{dodgr_full_cycles}()},
\code{\link{dodgr_fundamental_cycles}()},
\code{\link{dodgr_insert_vertex}()},
\code{\link{dodgr_sample}()},
\code{\link{dodgr_sflines_to_poly}()},
\code{\link{dodgr_vertices}()},
\code{\link{merge_directed_graph}()},
\code{\link{write_dodgr_wt_profile}()}
}
\concept{misc}
