% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_iter.R
\name{EM_iter}
\alias{EM_iter}
\title{Expectation-maximization algorithm for 1D data}
\usage{
EM_iter(X, alpha, mu, sig, Y = NULL, opts = NULL)
}
\arguments{
\item{X}{Vector of 1D data for GMM decomposition.}

\item{alpha}{Vector containing the weights (alpha) for each component in the statistical model.}

\item{mu}{Vector containing the means (mu) for each component in the statistical model.}

\item{sig}{Vector containing the standard deviation (sigma) for each component in the statistical model.}

\item{Y}{Vector of counts, with the same length as "X".
Applies only to binned data (Y = NULL, by default).}

\item{opts}{Parameters of run saved in \code{\link{GMM_1D_opts}} variable.}
}
\value{
Returns a \code{list} of GMM parameter values that correspond to the local extremes for each component.\describe{
 \item{alpha}{Vector of optimal alpha (weights) values.}
 \item{mu}{Vector of optimal mu (means) values.}
 \item{sigma}{Vector of optimal sigma (standard devations) values.}
 \item{logLik}{Log-likelihood statistic for the estimated number of components.}
 \item{crit}{Value of the selected information criterion in local extreme of likelihood function.}
}
}
\description{
The function performs the EM algorithm to find the local maximum likelihood for the estimated Gaussian mixture parameters.
}
\examples{
data("example")
opts <- GMM_1D_opts
Y <- matrix(1, 1, length(example$Dist))
rcpt <- EM_iter(example$Dist, 1, mean(example$Dist), sd(example$Dist), Y, opts)

}
\seealso{
\code{\link{runGMM}} and \code{\link{gaussian_mixture_vector}}
}
