% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_functions.R
\name{predict_coding_impact}
\alias{predict_coding_impact}
\title{Create Coding Impact Meta-prediction Score Data Frame}
\usage{
predict_coding_impact(
  annovar_csv_path,
  keep_highest_score = TRUE,
  keep_single_symbol = TRUE,
  na.string = "."
)
}
\arguments{
\item{annovar_csv_path}{path to 'ANNOVAR' csv output file}

\item{keep_highest_score}{boolean to indicate whether to keep only the maximal
impact score per gene (default = \code{TRUE}). If \code{FALSE}, all scores
per each gene are returned}

\item{keep_single_symbol}{in ANNOVAR outputs, a variant may be annotated as
exonic in multiple genes. This boolean argument controls whether or not to
keep only the first encountered symbol for a variant (default = \code{TRUE})}

\item{na.string}{string that was used to indicate when a score is not available
during annotation with ANNOVAR (default = '.')}
}
\value{
data frame of meta-prediction scores containing 2 columns: \describe{
\item{gene_symbol}{HGNC gene symbol}
\item{metaprediction_score}{metapredictor impact score}
}
}
\description{
Create Coding Impact Meta-prediction Score Data Frame
}
\examples{
path2annovar_csv <- system.file('extdata/example.hg19_multianno.csv',
                                package = 'driveR')
metapred_df <- predict_coding_impact(path2annovar_csv)
}
