#-------------------------------------------------------------------------------
# Copyright (c) 2019-2022 University of Newcastle upon Tyne. All rights reserved.
# Copyright (c) 2022-2025 Arjuna Technologies, Newcastle upon Tyne. All rights reserved.
#
# This program and the accompanying materials
# are made available under the terms of the GNU Public License v3.0.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#-------------------------------------------------------------------------------

#
# Set up
#

# context("ds.glmSLMA::smk::setup")

connect.studies.dataset.cnsim(list("LAB_TSC", "LAB_TRIG", "MEDI_LPD", "DIS_AMI", "DIS_DIAB", "GENDER"))

test_that("setup", {
    ds_expect_variables(c("D"))
})

#
# Tests
#

# context("ds.glmSLMA::smk::gaussian")
test_that("simple glmSLMA, gaussian", {
    glmSLMA.res <- ds.glmSLMA('D$LAB_TSC~D$LAB_TRIG', family="gaussian")

    expect_length(glmSLMA.res, 9)
    expect_equal(glmSLMA.res$num.valid.studies, 3)
    expect_true("matrix" %in% class(glmSLMA.res$betamatrix.all))
    expect_true("matrix" %in% class(glmSLMA.res$sematrix.all))
    expect_true("matrix" %in% class(glmSLMA.res$betamatrix.valid))
    expect_true("matrix" %in% class(glmSLMA.res$sematrix.valid))
    expect_true("matrix" %in% class(glmSLMA.res$SLMA.pooled.ests.matrix))
    expect_length(glmSLMA.res$output.summary, 5)
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$input.beta.matrix.for.SLMA))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$input.se.matrix.for.SLMA))
    expect_length(glmSLMA.res$output.summary$study1, 29)
    expect_true("family" %in% class(glmSLMA.res$output.summary$study1$family))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$study1$coefficients))
    expect_equal(glmSLMA.res$output.summary$study1$rank, 2)
    expect_equal(glmSLMA.res$output.summary$study1$aic, 5460.549, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study1$iter, 2)
    expect_equal(glmSLMA.res$output.summary$study1$contrasts, NULL)
    expect_equal(glmSLMA.res$output.summary$study1$dispersion, 1.211496, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study1$Ntotal, 2163)
    expect_equal(glmSLMA.res$output.summary$study1$Nvalid, 1801)
    expect_equal(glmSLMA.res$output.summary$study1$Nmissing, 362)
    expect_length(glmSLMA.res$output.summary$study2, 29)
    expect_true("family" %in% class(glmSLMA.res$output.summary$study2$family))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$study2$coefficients))
    expect_equal(glmSLMA.res$output.summary$study2$rank, 2)
    expect_equal(glmSLMA.res$output.summary$study2$aic, 7490.000, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study2$iter, 2)
    expect_equal(glmSLMA.res$output.summary$study2$contrasts, NULL)
    expect_equal(glmSLMA.res$output.summary$study2$dispersion, 1.13414, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study2$Ntotal, 3088)
    expect_equal(glmSLMA.res$output.summary$study2$Nvalid, 2526)
    expect_equal(glmSLMA.res$output.summary$study2$Nmissing, 562)
    expect_length(glmSLMA.res$output.summary$study3, 29)
    expect_true("family" %in% class(glmSLMA.res$output.summary$study3$family))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$study3$coefficients))
    expect_equal(glmSLMA.res$output.summary$study3$rank, 2)
    expect_equal(glmSLMA.res$output.summary$study3$aic, 10256.000, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study3$iter, 2)
    expect_equal(glmSLMA.res$output.summary$study3$contrasts, NULL)
    expect_equal(glmSLMA.res$output.summary$study3$dispersion, 1.12, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study3$Ntotal, 4128)
    expect_equal(glmSLMA.res$output.summary$study3$Nvalid, 3473)
    expect_equal(glmSLMA.res$output.summary$study3$Nmissing, 655)
    expect_length(glmSLMA.res$is.object.created, 1)
    expect_equal(glmSLMA.res$is.object.created, "A data object <new.glm.obj> has been created in all specified data sources")
    expect_length(glmSLMA.res$validity.check, 1)
    expect_equal(glmSLMA.res$validity.check, "<new.glm.obj> appears valid in all sources")
})

# context("ds.glmSLMA::smk::gaussian-assigned")
test_that("simple glmSLMA, gaussian-assigned", {
    glmSLMA.res <- ds.glmSLMA('D$LAB_TSC~D$LAB_TRIG', family="gaussian", newobj="glmSLMA_1.newobj")
    
    expect_length(glmSLMA.res, 9)
    expect_equal(glmSLMA.res$num.valid.studies, 3)
    expect_true("matrix" %in% class(glmSLMA.res$betamatrix.all))
    expect_true("matrix" %in% class(glmSLMA.res$sematrix.all))
    expect_true("matrix" %in% class(glmSLMA.res$betamatrix.valid))
    expect_true("matrix" %in% class(glmSLMA.res$sematrix.valid))
    expect_true("matrix" %in% class(glmSLMA.res$SLMA.pooled.ests.matrix))
    expect_length(glmSLMA.res$output.summary, 5)
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$input.beta.matrix.for.SLMA))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$input.se.matrix.for.SLMA))
    expect_length(glmSLMA.res$output.summary$study1, 29)
    expect_true("family" %in% class(glmSLMA.res$output.summary$study1$family))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$study1$coefficients))
    expect_equal(glmSLMA.res$output.summary$study1$rank, 2)
    expect_equal(glmSLMA.res$output.summary$study1$aic, 5460.549, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study1$iter, 2)
    expect_equal(glmSLMA.res$output.summary$study1$contrasts, NULL)
    expect_equal(glmSLMA.res$output.summary$study1$dispersion, 1.211496, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study1$Ntotal, 2163)
    expect_equal(glmSLMA.res$output.summary$study1$Nvalid, 1801)
    expect_equal(glmSLMA.res$output.summary$study1$Nmissing, 362)
    expect_length(glmSLMA.res$output.summary$study2, 29)
    expect_true("family" %in% class(glmSLMA.res$output.summary$study2$family))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$study2$coefficients))
    expect_equal(glmSLMA.res$output.summary$study2$rank, 2)
    expect_equal(glmSLMA.res$output.summary$study2$aic, 7490.000, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study2$iter, 2)
    expect_equal(glmSLMA.res$output.summary$study2$contrasts, NULL)
    expect_equal(glmSLMA.res$output.summary$study2$dispersion, 1.13414, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study2$Ntotal, 3088)
    expect_equal(glmSLMA.res$output.summary$study2$Nvalid, 2526)
    expect_equal(glmSLMA.res$output.summary$study2$Nmissing, 562)
    expect_length(glmSLMA.res$output.summary$study3, 29)
    expect_true("family" %in% class(glmSLMA.res$output.summary$study3$family))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$study3$coefficients))
    expect_equal(glmSLMA.res$output.summary$study3$rank, 2)
    expect_equal(glmSLMA.res$output.summary$study3$aic, 10256.000, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study3$iter, 2)
    expect_equal(glmSLMA.res$output.summary$study3$contrasts, NULL)
    expect_equal(glmSLMA.res$output.summary$study3$dispersion, 1.12, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study3$Ntotal, 4128)
    expect_equal(glmSLMA.res$output.summary$study3$Nvalid, 3473)
    expect_equal(glmSLMA.res$output.summary$study3$Nmissing, 655)
    expect_length(glmSLMA.res$is.object.created, 1)
    expect_equal(glmSLMA.res$is.object.created, "A data object <glmSLMA_1.newobj> has been created in all specified data sources")
    expect_length(glmSLMA.res$validity.check, 1)
    expect_equal(glmSLMA.res$validity.check, "<glmSLMA_1.newobj> appears valid in all sources")
})

# context("ds.glmSLMA::smk::binomial")
test_that("simple glmSLMA, binomial", {
    ds.asCharacter('D$MEDI_LPD', 'str.medi.lpd')
    ds.asNumeric('str.medi.lpd', 'num.medi.lpd')
    ds.asCharacter('D$GENDER',   'str.gender')
    ds.asNumeric('str.gender',   'num.gender')
    ds.asCharacter('D$DIS_DIAB', 'str.dis.diab')
    ds.asNumeric('str.dis.diab', 'num.dis.diab')

    glmSLMA.res <- ds.glmSLMA('num.medi.lpd~num.gender*num.dis.diab', family="binomial")

    expect_length(glmSLMA.res, 9)
    expect_equal(glmSLMA.res$num.valid.studies, 3)
    expect_true("matrix" %in% class(glmSLMA.res$betamatrix.all))
    expect_true("matrix" %in% class(glmSLMA.res$sematrix.all))
    expect_true("matrix" %in% class(glmSLMA.res$betamatrix.valid))
    expect_true("matrix" %in% class(glmSLMA.res$sematrix.valid))
    expect_true("matrix" %in% class(glmSLMA.res$SLMA.pooled.ests.matrix))
    expect_length(glmSLMA.res$output.summary, 5)
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$input.beta.matrix.for.SLMA))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$input.se.matrix.for.SLMA))
    expect_length(glmSLMA.res$output.summary$study1, 29)
    expect_true("family" %in% class(glmSLMA.res$output.summary$study1$family))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$study1$coefficients))
    expect_equal(glmSLMA.res$output.summary$study1$rank, 4)
    expect_equal(glmSLMA.res$output.summary$study1$aic, 442.507, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study1$iter, 15)
    expect_equal(glmSLMA.res$output.summary$study1$contrasts, NULL)
    expect_equal(glmSLMA.res$output.summary$study1$dispersion, 1.000, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study1$Ntotal, 2163)
    expect_equal(glmSLMA.res$output.summary$study1$Nvalid, 2163)
    expect_equal(glmSLMA.res$output.summary$study1$Nmissing, 0)
    expect_length(glmSLMA.res$output.summary$study2, 29)
    expect_true("family" %in% class(glmSLMA.res$output.summary$study2$family))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$study2$coefficients))
    expect_equal(glmSLMA.res$output.summary$study2$rank, 4)
    expect_equal(glmSLMA.res$output.summary$study2$aic, 568, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study2$iter, 7)
    expect_equal(glmSLMA.res$output.summary$study2$contrasts, NULL)
    expect_equal(glmSLMA.res$output.summary$study2$dispersion, 1.00, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study2$Ntotal, 3088)
    expect_equal(glmSLMA.res$output.summary$study2$Nvalid, 3088)
    expect_equal(glmSLMA.res$output.summary$study2$Nmissing, 0)
    expect_length(glmSLMA.res$output.summary$study3, 29)
    expect_true("family" %in% class(glmSLMA.res$output.summary$study3$family))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$study3$coefficients))
    expect_equal(glmSLMA.res$output.summary$study3$rank, 4)
    expect_equal(glmSLMA.res$output.summary$study3$aic, 673, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study3$iter, 7)
    expect_equal(glmSLMA.res$output.summary$study3$contrasts, NULL)
    expect_equal(glmSLMA.res$output.summary$study3$dispersion, 1.00, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study3$Ntotal, 4128)
    expect_equal(glmSLMA.res$output.summary$study3$Nvalid, 4128)
    expect_equal(glmSLMA.res$output.summary$study3$Nmissing, 0)
    expect_length(glmSLMA.res$is.object.created, 1)
    expect_equal(glmSLMA.res$is.object.created, "A data object <new.glm.obj> has been created in all specified data sources")
    expect_length(glmSLMA.res$validity.check, 1)
    expect_equal(glmSLMA.res$validity.check, "<new.glm.obj> appears valid in all sources")
})

# context("ds.glmSLMA::smk::binomial-assigned")
test_that("simple glmSLMA, binomial-assigned", {
    ds.asCharacter('D$MEDI_LPD', 'str.medi.lpd')
    ds.asNumeric('str.medi.lpd', 'num.medi.lpd')
    ds.asCharacter('D$GENDER',   'str.gender')
    ds.asNumeric('str.gender',   'num.gender')
    ds.asCharacter('D$DIS_DIAB', 'str.dis.diab')
    ds.asNumeric('str.dis.diab', 'num.dis.diab')

    glmSLMA.res <- ds.glmSLMA('num.medi.lpd~num.gender*num.dis.diab', family="binomial", newobj="glmSLMA_2.newobj")

    expect_length(glmSLMA.res, 9)
    expect_equal(glmSLMA.res$num.valid.studies, 3)
    expect_true("matrix" %in% class(glmSLMA.res$betamatrix.all))
    expect_true("matrix" %in% class(glmSLMA.res$sematrix.all))
    expect_true("matrix" %in% class(glmSLMA.res$betamatrix.valid))
    expect_true("matrix" %in% class(glmSLMA.res$sematrix.valid))
    expect_true("matrix" %in% class(glmSLMA.res$SLMA.pooled.ests.matrix))
    expect_length(glmSLMA.res$output.summary, 5)
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$input.beta.matrix.for.SLMA))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$input.se.matrix.for.SLMA))
    expect_length(glmSLMA.res$output.summary$study1, 29)
    expect_true("family" %in% class(glmSLMA.res$output.summary$study1$family))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$study1$coefficients))
    expect_equal(glmSLMA.res$output.summary$study1$rank, 4)
    expect_equal(glmSLMA.res$output.summary$study1$aic, 442.507, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study1$iter, 15)
    expect_equal(glmSLMA.res$output.summary$study1$contrasts, NULL)
    expect_equal(glmSLMA.res$output.summary$study1$dispersion, 1.000, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study1$Ntotal, 2163)
    expect_equal(glmSLMA.res$output.summary$study1$Nvalid, 2163)
    expect_equal(glmSLMA.res$output.summary$study1$Nmissing, 0)
    expect_length(glmSLMA.res$output.summary$study2, 29)
    expect_true("family" %in% class(glmSLMA.res$output.summary$study2$family))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$study2$coefficients))
    expect_equal(glmSLMA.res$output.summary$study2$rank, 4)
    expect_equal(glmSLMA.res$output.summary$study2$aic, 568, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study2$iter, 7)
    expect_equal(glmSLMA.res$output.summary$study2$contrasts, NULL)
    expect_equal(glmSLMA.res$output.summary$study2$dispersion, 1.00, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study2$Ntotal, 3088)
    expect_equal(glmSLMA.res$output.summary$study2$Nvalid, 3088)
    expect_equal(glmSLMA.res$output.summary$study2$Nmissing, 0)
    expect_length(glmSLMA.res$output.summary$study3, 29)
    expect_true("family" %in% class(glmSLMA.res$output.summary$study3$family))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$study3$coefficients))
    expect_equal(glmSLMA.res$output.summary$study3$rank, 4)
    expect_equal(glmSLMA.res$output.summary$study3$aic, 673, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study3$iter, 7)
    expect_equal(glmSLMA.res$output.summary$study3$contrasts, NULL)
    expect_equal(glmSLMA.res$output.summary$study3$dispersion, 1.00, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study3$Ntotal, 4128)
    expect_equal(glmSLMA.res$output.summary$study3$Nvalid, 4128)
    expect_equal(glmSLMA.res$output.summary$study3$Nmissing, 0)
    expect_length(glmSLMA.res$is.object.created, 1)
    expect_equal(glmSLMA.res$is.object.created, "A data object <glmSLMA_2.newobj> has been created in all specified data sources")
    expect_length(glmSLMA.res$validity.check, 1)
    expect_equal(glmSLMA.res$validity.check, "<glmSLMA_2.newobj> appears valid in all sources")
})

# context("ds.glmSLMA::smk::poisson")
test_that("simple glmSLMA, poisson", {
    glmSLMA.res <- ds.glmSLMA('D$LAB_TSC~D$LAB_TRIG', family="poisson")

    expect_length(glmSLMA.res, 9)
    expect_equal(glmSLMA.res$num.valid.studies, 3)
    expect_true("matrix" %in% class(glmSLMA.res$betamatrix.all))
    expect_true("matrix" %in% class(glmSLMA.res$sematrix.all))
    expect_true("matrix" %in% class(glmSLMA.res$betamatrix.valid))
    expect_true("matrix" %in% class(glmSLMA.res$sematrix.valid))
    expect_true("matrix" %in% class(glmSLMA.res$SLMA.pooled.ests.matrix))
    expect_length(glmSLMA.res$output.summary, 5)
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$input.beta.matrix.for.SLMA))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$input.se.matrix.for.SLMA))
    expect_length(glmSLMA.res$output.summary$study1, 29)
    expect_true("family" %in% class(glmSLMA.res$output.summary$study1$family))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$study1$coefficients))
    expect_equal(glmSLMA.res$output.summary$study1$rank, 2)
    expect_equal(glmSLMA.res$output.summary$study1$aic, Inf, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study1$iter, 4)
    expect_equal(glmSLMA.res$output.summary$study1$contrasts, NULL)
    expect_equal(glmSLMA.res$output.summary$study1$dispersion, 1.000, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study1$Ntotal, 2163)
    expect_equal(glmSLMA.res$output.summary$study1$Nvalid, 1801)
    expect_equal(glmSLMA.res$output.summary$study1$Nmissing, 362)
    expect_length(glmSLMA.res$output.summary$study2, 29)
    expect_true("family" %in% class(glmSLMA.res$output.summary$study2$family))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$study2$coefficients))
    expect_equal(glmSLMA.res$output.summary$study2$rank, 2)
    expect_equal(glmSLMA.res$output.summary$study2$aic, Inf, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study2$iter, 4)
    expect_equal(glmSLMA.res$output.summary$study2$contrasts, NULL)
    expect_equal(glmSLMA.res$output.summary$study2$dispersion, 1.00, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study2$Ntotal, 3088)
    expect_equal(glmSLMA.res$output.summary$study2$Nvalid, 2526)
    expect_equal(glmSLMA.res$output.summary$study2$Nmissing, 562)
    expect_length(glmSLMA.res$output.summary$study3, 29)
    expect_true("family" %in% class(glmSLMA.res$output.summary$study3$family))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$study3$coefficients))
    expect_equal(glmSLMA.res$output.summary$study3$rank, 2)
    expect_equal(glmSLMA.res$output.summary$study3$aic, Inf, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study3$iter, 4)
    expect_equal(glmSLMA.res$output.summary$study3$contrasts, NULL)
    expect_equal(glmSLMA.res$output.summary$study3$dispersion, 1.00, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study3$Ntotal, 4128)
    expect_equal(glmSLMA.res$output.summary$study3$Nvalid, 3473)
    expect_equal(glmSLMA.res$output.summary$study3$Nmissing, 655)
    expect_length(glmSLMA.res$is.object.created, 1)
    expect_equal(glmSLMA.res$is.object.created, "A data object <new.glm.obj> has been created in all specified data sources")
    expect_length(glmSLMA.res$validity.check, 1)
    expect_equal(glmSLMA.res$validity.check, "<new.glm.obj> appears valid in all sources")
})

# context("ds.glmSLMA::smk::poisson-assigned")
test_that("simple glmSLMA, poisson-assigned", {
    glmSLMA.res <- ds.glmSLMA('D$LAB_TSC~D$LAB_TRIG', family="poisson", newobj="glmSLMA_3.newobj")

    expect_length(glmSLMA.res, 9)
    expect_equal(glmSLMA.res$num.valid.studies, 3)
    expect_true("matrix" %in% class(glmSLMA.res$betamatrix.all))
    expect_true("matrix" %in% class(glmSLMA.res$sematrix.all))
    expect_true("matrix" %in% class(glmSLMA.res$betamatrix.valid))
    expect_true("matrix" %in% class(glmSLMA.res$sematrix.valid))
    expect_true("matrix" %in% class(glmSLMA.res$SLMA.pooled.ests.matrix))
    expect_length(glmSLMA.res$output.summary, 5)
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$input.beta.matrix.for.SLMA))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$input.se.matrix.for.SLMA))
    expect_length(glmSLMA.res$output.summary$study1, 29)
    expect_true("family" %in% class(glmSLMA.res$output.summary$study1$family))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$study1$coefficients))
    expect_equal(glmSLMA.res$output.summary$study1$rank, 2)
    expect_equal(glmSLMA.res$output.summary$study1$aic, Inf, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study1$iter, 4)
    expect_equal(glmSLMA.res$output.summary$study1$contrasts, NULL)
    expect_equal(glmSLMA.res$output.summary$study1$dispersion, 1.000, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study1$Ntotal, 2163)
    expect_equal(glmSLMA.res$output.summary$study1$Nvalid, 1801)
    expect_equal(glmSLMA.res$output.summary$study1$Nmissing, 362)
    expect_length(glmSLMA.res$output.summary$study2, 29)
    expect_true("family" %in% class(glmSLMA.res$output.summary$study2$family))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$study2$coefficients))
    expect_equal(glmSLMA.res$output.summary$study2$rank, 2)
    expect_equal(glmSLMA.res$output.summary$study2$aic, Inf, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study2$iter, 4)
    expect_equal(glmSLMA.res$output.summary$study2$contrasts, NULL)
    expect_equal(glmSLMA.res$output.summary$study2$dispersion, 1.00, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study2$Ntotal, 3088)
    expect_equal(glmSLMA.res$output.summary$study2$Nvalid, 2526)
    expect_equal(glmSLMA.res$output.summary$study2$Nmissing, 562)
    expect_length(glmSLMA.res$output.summary$study3, 29)
    expect_true("family" %in% class(glmSLMA.res$output.summary$study3$family))
    expect_true("matrix" %in% class(glmSLMA.res$output.summary$study3$coefficients))
    expect_equal(glmSLMA.res$output.summary$study3$rank, 2)
    expect_equal(glmSLMA.res$output.summary$study3$aic, Inf, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study3$iter, 4)
    expect_equal(glmSLMA.res$output.summary$study3$contrasts, NULL)
    expect_equal(glmSLMA.res$output.summary$study3$dispersion, 1.00, tolerance = 0.001)
    expect_equal(glmSLMA.res$output.summary$study3$Ntotal, 4128)
    expect_equal(glmSLMA.res$output.summary$study3$Nvalid, 3473)
    expect_equal(glmSLMA.res$output.summary$study3$Nmissing, 655)
    expect_length(glmSLMA.res$is.object.created, 1)
    expect_equal(glmSLMA.res$is.object.created, "A data object <glmSLMA_3.newobj> has been created in all specified data sources")
    expect_length(glmSLMA.res$validity.check, 1)
    expect_equal(glmSLMA.res$validity.check, "<glmSLMA_3.newobj> appears valid in all sources")
})

#
# Done
#

# context("ds.glmSLMA::smk::shutdown")

test_that("shutdown", {
    ds_expect_variables(c("D", "new.glm.obj", "glmSLMA_1.newobj", "glmSLMA_2.newobj", "glmSLMA_3.newobj", "num.medi.lpd", "num.dis.diab", "num.gender", "str.medi.lpd", "str.dis.diab", "str.gender"))

})

disconnect.studies.dataset.cnsim()

# context("ds.glmSLMA::smk::done")
