% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create_sequence}
\alias{create_sequence}
\title{Simulate a sequence for states of choice.}
\usage{
create_sequence(states, len = 5000, probs = NULL, seed = NULL)
}
\arguments{
\item{states}{Character vector of unique values. If given the value
"DNA" the values c("a", "c", "g", "t") are given instead.}

\item{len}{Optional. Positive integer with the default value
equal to 5000.}

\item{probs}{Optional. Numeric vector with values interpreted as
probabilities for each of the states in \code{states}. Default value
is equal to 1 over the number of states given, for every state.}

\item{seed}{Optional. Object specifying the initialization of the random
number generator (see more in \code{\link[base:set.seed]{set.seed}}).}
}
\value{
A character sequence of length \code{len}.
}
\description{
This is a wrapper function around \code{sample()}.
}
\examples{
# This is equal to having the argument `probs = c(1/4, 1/4, 1/4, 1/4)`.
rand_dna_seq <- create_sequence(states = "DNA")
table(rand_dna_seq)

random_letters <- sample(letters, size = 5, replace = FALSE)
rand_dna_seq2 <- create_sequence(
    states = random_letters,
    probs = c(0.6, 0.3, 0.05, 0.025, 0.025),
    len = 10000)
table(rand_dna_seq2)
}
\seealso{
For the simulation of a sequence with a drifting semi-Markov kernel:
\link{simulate.dsmm}.

The original function: \code{\link[base:sample]{sample}}.

About random number generation in R: \code{\link[base:RNG]{RNG}}.

For the theoretical background of drifting semi-Markov models: \link{dsmmR}.
}
