% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.dsp}
\alias{predict.dsp}
\title{Predict changepoints from the output of ABCO}
\usage{
\method{predict}{dsp}(object, cp_thres = 0.5, cp_prop = FALSE, ...)
}
\arguments{
\item{object}{object of class dsp from \code{\link[=dsp_fit]{dsp_fit()}}}

\item{cp_thres}{(default 0.5) cutoff proportion for percentage of posterior
samples exceeding the threshold needed to label a changepoint}

\item{cp_prop}{(default FALSE) logical flag determining if the posterior proportions of threshold exceedance is to be returned.}

\item{...}{currently unused}
}
\value{
If cp_prop = FALSE, a numeric vector of indices that correspond to indices of the observed data.
If cp_prop = TRUE, a list containing:

\if{html}{\out{<div class="sourceCode">}}\preformatted{- 'cp_t':  a numeric vector of indices that correspond to indices of the observed data.
- 'cp_prop': a numeric vector of length (T - D) with the pointwise proportion of samples where the increment exceeds the threshold.
}\if{html}{\out{</div>}}

If no proportions exceed cp_thres, then the vector will be a length 0 integer vector.
}
\description{
Predict changepoints from the output of ABCO
}
\details{
The changepoint model uses a thresholding mechanism with a latent indicator variable.
This function calculates the proportion of samples where the increment exceeds the threshold.
}
\examples{
set.seed(200)
signal = c(rep(0, 50), rep(10, 50))
noise = rep(1, 100)
noise_var = rep(1, 100)
for (k in 2:100){
  noise_var[k] = exp(0.9*log(noise_var[k-1]) + rnorm(1, 0, 0.5))
  noise[k] = rnorm(1, 0, sqrt(noise_var[k])) }

y = signal + noise
model_spec = dsp_spec(family = "gaussian", model = "changepoint",
                      D = 1, useAnom = TRUE)
mcmc_output = dsp_fit(y, model_spec = model_spec, nsave = 500, nburn = 500)
predict(mcmc_output)

}
