% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/component_samplers.R
\name{sampleLogVolMu0}
\alias{sampleLogVolMu0}
\title{Sample the mean of AR(1) unconditional means}
\usage{
sampleLogVolMu0(h_mu, h_mu0, dhs_mean_prec_j, h_log_scale = 0)
}
\arguments{
\item{h_mu}{the \code{p x 1} vector of means}

\item{h_mu0}{the previous mean of unconditional means}

\item{dhs_mean_prec_j}{the \code{p x 1} vector of precisions (from the Polya-Gamma parameter expansion)}

\item{h_log_scale}{prior mean from scale mixture of Gaussian (Polya-Gamma) prior, e.g. log(sigma_e^2)}
}
\value{
The sampled mean parameter \code{dhs_mean0}
}
\description{
Compute one draw of the mean of unconditional means in an AR(1) model with Gaussian innovations
and time-dependent innovation variances (for p > 1). More generally, the sampler
applies to the "mean" parameter (on the log-scale) for a Polya-Gamma parameter expanded
hierarchical model.
}
\note{
This sampler is particularly for \code{p > 1} and the setting in which we want hierarchical
shrinkage effects, e.g. predictor- and time-dependent shrinkage, predictor-dependent shrinkage,
and global shrinkage, with a natural hierarchical ordering.
}
