% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tern.R
\name{tern_AET02_table}
\alias{tern_AET02_table}
\title{Generate AET02-style AE summary using \code{tern} and \code{rtables}}
\usage{
tern_AET02_table(
  adsl,
  adae,
  patient,
  treat,
  target = "AEDECOD",
  rows_by = "AEBODSYS",
  indent = "  "
)
}
\arguments{
\item{adsl}{Subject-level dataset.}

\item{adae}{Adverse event dataset.}

\item{patient}{Unique subject identifier variable.}

\item{treat}{Treatment arm variable.}

\item{target}{Preferred term variable (default: \code{"AEDECOD"}).}

\item{rows_by}{Higher-level nesting term (default: \code{"AEBODSYS"}).}

\item{indent}{Ignored (included for compatibility).}
}
\value{
A \code{TableTree} object with AE summary by SOC/PT.
}
\description{
This function builds a System Organ Class (SOC) and Preferred Term (PT)
adverse event summary table, following the AET02 CSR format, using the
\code{tern} and \code{rtables} packages.
}
\seealso{
\code{\link[=AET02_table]{AET02_table()}}
}
