# Generated by 02-duckplyr_df-methods.R
#' @rdname pull.duckplyr_df
#' @export
pull.duckplyr_df <- function(.data, var = -1, name = NULL, ...) {
  # dplyr implementation
  my_var <- tidyselect::vars_pull(names(.data), !!enquo(var))
  my_name <- enquo(name)
  if (!quo_is_null(my_name)) {
    my_name <- tidyselect::vars_pull(names(.data), !!my_name)
    my_var <- c(my_name, my_var)
  }

  loc <- set_names(match(my_var, names(.data)), my_var)

  exprs <- exprs_from_loc(.data, loc)

  duckplyr_error <- rel_try(list(name = "pull", .data = .data),
    #' @section Fallbacks:
    #' There is no DuckDB translation in `pull.duckplyr_df()`
    #' - with a selection that returns no columns.
    #'
    #' These features fall back to [dplyr::pull()], see `vignette("fallback")` for details.
    "Zero-column result set not supported." = (length(exprs) == 0),
    {
      rel <- duckdb_rel_from_df(.data)
      out_rel <- rel_project(rel, exprs)
      out <- rel_to_df(out_rel, prudence = "lavish")
      out <- tibble::deframe(out)
      return(out)
    }
  )

  # dplyr forward
  check_prudence(.data, duckplyr_error)

  pull <- dplyr$pull.data.frame
  out <- pull(.data, {{ var }}, {{ name }}, ...)
  return(out)

  # dplyr implementation
  var <- tidyselect::vars_pull(names(.data), !!enquo(var))
  name <- enquo(name)
  if (quo_is_null(name)) {
    return(.data[[var]])
  }
  name <- tidyselect::vars_pull(names(.data), !!name)
  set_names(.data[[var]], nm = .data[[name]])
}

duckplyr_pull <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df_impl(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- pull(.data, ...)
  out
}
