% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddbs_utils.R
\name{ddbs_stop_conn}
\alias{ddbs_stop_conn}
\title{Close a duckdb connection}
\usage{
ddbs_stop_conn(conn)
}
\arguments{
\item{conn}{A connection object to a DuckDB database}
}
\value{
TRUE (invisibly) for successful disconnection
}
\description{
Close a duckdb connection
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
## load packages
library(duckspatial)

## create an in-memory duckdb database
conn <- ddbs_create_conn(dbdir = "memory")

## close the connection
ddbs_stop_conn(conn)
\dontshow{\}) # examplesIf}
}
