% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dviGLR.R
\name{dviGLR}
\alias{dviGLR}
\title{Finds Generalised Likelihood Ratios (GLRs)}
\usage{
dviGLR(dvi, pairings = generatePairings(dvi), dviRes = NULL)
}
\arguments{
\item{dvi}{A \code{dviData} object.}

\item{pairings}{List. See details.}

\item{dviRes}{data frame. Output from \code{jointDVI()}.}
}
\value{
A data frame with GLRs and SGLR (strict GLR, max replaced by min in
the numerator).
}
\description{
Based on a \code{dviData} object, or output from \verb{dviJoint()``or }jointDVI()`,
the GLR, the ratio of the maximum likelihood under H0 to the maximum under H1,
is calculated for specified hypotheses.
}
\details{
The Generalised Likelihood Ratio (GLR) statistic is defined as the
ratio of the maximum likelihood for the alternatives in the numerator
to the maximum in the denominator. The default
\code{pairings = dvir::generatePairings(dvi)} tests all hypotheses. Specific
tests can be specified as shown in an example:
\code{pairings = list(V1 = "M1")} gives a test for H0: V1 = M1 against
H1: V1 != M1. \code{dviRes} will be calculated using \code{jointDVI()} if not provided.
}
\examples{
# dviGLR(example2, pairings = list(V1 = "M1"))

# All tests with output from jointDVI
# dviGLR(example2)

}
