% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDVI.R
\name{plotDVI}
\alias{plotDVI}
\title{Plot a DVI problem}
\usage{
plotDVI(
  dvi,
  pm = TRUE,
  am = TRUE,
  style = 1,
  famnames = NA,
  hatched = typedMembers,
  frames = TRUE,
  titles = c("PM", "AM"),
  cex = NA,
  col = 1,
  lwd = 1,
  fill = NA,
  carrier = NULL,
  widths = NULL,
  heights = NULL,
  nrowPM = NA,
  nrowAM = NA,
  dev.height = NULL,
  dev.width = NULL,
  newdev = !is.null(c(dev.height, dev.width)),
  ...
)
}
\arguments{
\item{dvi}{A \code{dviData} object, typically created with \code{\link[=dviData]{dviData()}}.}

\item{pm}{Either a logical indicating if the PM data should be plotted (as a
set of singletons), or a vector of indices selecting a subset of the PM
samples. Default: TRUE.}

\item{am}{Either a logical indicating if the AM families data should be
plotted, or a vector of indices selecting a subset of the families.
Default: TRUE.}

\item{style}{An integer (currently 1 or 2) indicating the style of the plot.}

\item{famnames}{A logical. If NA (default) family names are included if there
are multiple families.}

\item{hatched}{A character vector of ID labels, or the name of a function. By
default, typed individuals are hatched.}

\item{frames}{A logical, by default TRUE.}

\item{titles}{A character of length 2.}

\item{fill, cex, col, lwd, carrier}{Arguments passed on to \code{\link[pedtools:plot.ped]{pedtools::plot.ped()}}.}

\item{widths, heights}{Numeric with relative columns widths / row heights, to
be passed on to \code{layout()}.}

\item{nrowPM}{The number of rows in the array of PM singletons.}

\item{nrowAM}{The number of rows in the array of AM families.}

\item{dev.height, dev.width}{Plot height and widths in inches. These are
optional, and only relevant if \code{newdev = TRUE}.}

\item{newdev}{A logical indicating if a new plot window should be opened.}

\item{...}{Further parameters to be passed on to \code{\link[pedtools:plot.ped]{pedtools::plot.ped()}},
e.g., \code{marker}, \code{cex}, \code{cex.main}, \code{symbolsize}.}
}
\description{
Plot a DVI problem
}
\examples{

plotDVI(example2)

# Override default layout of PM singletons
plotDVI(example2, nrowPM = 1)

# Subset
plotDVI(example2, pm = 1:2, am = 1, titles = c("PM (1-2)", "AM (1)"))

# AM only
plotDVI(example2, pm = FALSE, titles = "AM families")

# Further plot options
plotDVI(example2, frames = FALSE, marker = 1, cex = 1.2, nrowPM = 3, nrowAM = 2,
  textAnnot = list(inside = list(c(M1 = "?", M2 = "?", M3 = "?"), cex = 1.5)))

}
