% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc_resample.R
\name{plot_resample_forest}
\alias{plot_resample_forest}
\title{Plot resample forest plots}
\usage{
plot_resample_forest(
  data,
  n_rows = 2,
  n_cols = 2,
  interactive = FALSE,
  ci_level = 0.95
)
}
\arguments{
\item{data}{List of abc results from abc_resample}

\item{n_rows}{Number of rows in plot grid (default 2)}

\item{n_cols}{Number of columns in plot grid (default 2)}

\item{interactive}{Whether to pause between pages (default FALSE)}

\item{ci_level}{quantile intervals (default 0.95 for 95\% interval)}
}
\value{
No return value, called for side effects (plotting). Creates forest
  plots displayed in the graphics device.
}
\description{
Create forest plots showing parameter ranges across resample iterations.
Each iteration is displayed as a horizontal line with quantile intervals.
}
\examples{
# Load ABC input data from example simulation
abc_input <- readRDS(
  system.file("extdata", "rdm_minimal", "abc", "abc_input.rds", package = "eam")
)

# Perform ABC resampling
results <- abc_resample(
  target = abc_input$target,
  param = abc_input$param,
  sumstat = abc_input$sumstat,
  n_iterations = 100,
  n_samples = 100,
  tol = 0.5,
  method = "rejection"
)

# plot forest plots showing parameter ranges
plot_resample_forest(results, ci_level = 0.95)
}
