
out_dir <- "./tests-output/"
dir.create(out_dir, showWarnings = FALSE)

###################################
test_that("1. dat1", {

out_file <- paste0(out_dir, 'test_ArrayToNc_1.nc')

tos <- array(1:400, dim = c(5, 10, 4))
metadata <- list(tos = list(units = 'K'))
attr(tos, 'variables') <- metadata
names(dim(tos)) <- c('lat', 'lon', 'time')

lon <- seq(0, 360 - 360 / 10, length.out = 10)
dim(lon) <- c(lon = 10)
metadata <- list(lon = list(units = 'degrees_east'))
attr(lon, 'variables') <- metadata

lat <- seq(-90, 90, length.out = 5)
dim(lat) <- c(lat = 5)
metadata <- list(lat = list(units = 'degrees_north'))
attr(lat, 'variables') <- metadata

#time_attr <- as.POSIXct(paste0("1970-03-" 3:6, " 12:00:00"), tz = 'UTC')
time_attr <- 3:6
dim(time_attr) <- c(time = 4)
metadata <- list(time = list(units = 'days since 1970-03-01 12:00:00',
                             calendar = 'standard'))
attr(time_attr, 'variables') <- metadata

ArrayToNc(list(tos, lon, lat, time_attr), out_file)

dat1 <- NcToArray(out_file, vars_to_read = 'tos')
lon1 <- NcToArray(out_file, vars_to_read = 'lon')
lat1 <- NcToArray(out_file, vars_to_read = 'lat')

expect_equal(
c(tos),
c(dat1)
)
expect_equal(
names(attributes(dat1)$variables$tos),
c("prec", "units", "dim", "unlim", "make_missing_value", "missval", "hasAddOffset", "hasScaleFact")
)
expect_equal(
attributes(dat1)$variables$tos$prec,
"int"
)
expect_equal(
attributes(dat1)$variables$tos$units,
"K"
)
expect_equal(
length(attributes(dat1)$variables$tos$dim),
3
)
expect_equal(
sapply(attributes(dat1)$variables$tos$dim, '[[', 1),
c("lat", "lon", "time")
)
expect_equal(
c(lon),
c(lon1)
)
expect_equal(
attributes(lon1)$variables$lon$units,
"degrees_east"
)
expect_equal(
c(lat),
c(lat1)
)
expect_equal(
attributes(lat1)$variables$lat$units,
"degrees_north"
)

# Delete files
unlink(out_file, recursive = TRUE)

})

###################################
test_that("2. var", {

out_file <- paste0(out_dir, 'test_ArrayToNc_2.nc')

a <- array(1:27, dim = c(3, 3, 3))
names(dim(a)) <- c('lon', 'lat', 'var')
ArrayToNc(a, out_file)

dat2_1 <- NcToArray(out_file, vars_to_read = 'var1_1')
dat2_2 <- NcToArray(out_file, vars_to_read = 'var1_2')
dat2_3 <- NcToArray(out_file, vars_to_read = 'var1_3')

expect_equal(
c(a),
c(c(dat2_1), c(dat2_2), c(dat2_3))
)
expect_equal(
names(attributes(dat2_1)$variables$var1_1),
c("prec", "units", "dim", "unlim", "make_missing_value", "missval", "hasAddOffset", "hasScaleFact")
)
expect_equal(
names(attributes(dat2_2)$variables$var1_2),
names(attributes(dat2_1)$variables$var1_1)
)
expect_equal(
names(attributes(dat2_3)$variables$var1_3),
names(attributes(dat2_1)$variables$var1_1)
)
expect_equal(
dim(dat2_1),
c(var = 1, lon = 3, lat = 3)
)
expect_equal(
dim(dat2_2),
dim(dat2_1)
)
expect_equal(
dim(dat2_3),
dim(dat2_1)
)

# Delete files
unlink(out_file, recursive = TRUE)

})

test_that("3. var & addOffset, scaleFactor", {

out_file <- paste0(out_dir, 'test_ArrayToNc_3.nc')

a <- array(1:400, dim = c(5, 10, 4, 2))
metadata <- list(
              tos = list(addOffset = 100,
                         scaleFact = 10),
              tas = list(addOffset = 100,
                         scaleFact = 10))
attr(a, 'variables') <- metadata
names(dim(a)) <- c('lat', 'lon', 'time', 'var')
ArrayToNc(a, out_file)

dat3_1 <- NcToArray(out_file, vars_to_read = 'tos')
dat3_2 <- NcToArray(out_file, vars_to_read = 'tas')

expect_equal(
c(dat3_1),
c(rep(seq(10, 90, 10), each = 10), rep(100, 19), rep(seq(110, 190, 10), each = 10), 200)
)
expect_equal(
c(dat3_2),
c(rep(200, 9), rep(seq(210, 390, 10), each = 10), 400)
)
expect_equal(
dim(dat3_1),
c(var = 1, lat = 5, lon = 10, time = 4)
)
expect_equal(
names(attributes(dat3_1)$variables$tos),
c("prec", "units", "dim", "unlim", "make_missing_value", "missval", "hasAddOffset", "addOffset", "hasScaleFact", "scaleFact", "scale_factor", "add_offset")
)
expect_equal(
names(attributes(dat3_2)$variables$tas),
c("prec", "units", "dim", "unlim", "make_missing_value", "missval", "hasAddOffset", "addOffset", "hasScaleFact", "scaleFact", "scale_factor", "add_offset")
)
expect_equal(
(attributes(dat3_2)$variables$tas$add_offset),
100
)
expect_equal(
attributes(dat3_2)$variables$tas$hasAddOffset,
TRUE
)

# Delete files
unlink(out_file, recursive = TRUE)

})


