% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{epm_import_xml}
\alias{epm_import_xml}
\title{Import PubMed Records from Local Files.}
\usage{
epm_import_xml(x)
}
\arguments{
\item{x}{Character vector, the paths to text files including 
XML-decorated raw PubMed records saved using `easyPubMed>3.0`.}
}
\value{
an `easyPubMed` object including raw XML PubMed records.
}
\description{
Read one or more text files including XML-decorated raw PubMed records 
and rebuild an `easyPubMed` object. The function expects all files to be
generated from the same query using `easyPubMed>3.0` and the 
`epm_fetch()` function setting `write_to_file` to `TRUE`. This 
function can import a fraction or all of the files 
resulting from a single query. Files resulting
from non-compatible fetch jobs will be dropped.
}
\examples{
# Note: a time limit can be set in order to kill the operation when/if 
# the NCBI/Entrez server becomes unresponsive.
setTimeLimit(elapsed = 4.9)
try({
  x <- epm_query(query_string = 'Damiano Fantini[AU] AND "2018"[PDAT]')
  x <- epm_fetch(x = x, format = 'xml', write_to_file = TRUE, 
                 outfile_prefix = 'test', store_contents = FALSE)
  y <- epm_import_xml('test_batch_01.txt')
  tryCatch({unlink('test_batch_01.txt')}, error = function(e) { NULL }) 
  print(paste0('       Raw Record Num (fetched): ', 
               getEPMMeta(x)$raw_record_num))
  print(paste0('Raw Record Num (read & rebuilt): ', 
               getEPMMeta(y)$raw_record_num))
}, silent = TRUE)
setTimeLimit(elapsed = Inf)

 

}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
