% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_surrogate_fx.R
\name{table_articles_byAuth}
\alias{table_articles_byAuth}
\title{Extract Publication and Affiliation Data from PubMed Records}
\usage{
table_articles_byAuth(
  pubmed_data,
  included_authors = "all",
  max_chars = 500,
  autofill = TRUE,
  dest_file = NULL,
  getKeywords = TRUE,
  encoding = "UTF8"
)
}
\arguments{
\item{pubmed_data}{PubMed Data in XML format: typically, an XML file resulting from a 
batch_pubmed_download() call or an XML object, result of a fetch_pubmed_data() call.}

\item{included_authors}{Character: c("first", "last", "all"). Only includes information 
from the first, the last or all authors of a PubMed record.}

\item{max_chars}{This argument is ignored. In this version of the function, 
the whole Abstract Text is returned.}

\item{autofill}{Logical. If TRUE, missing affiliations are imputed according to the available 
values (from the same article).}

\item{dest_file}{String (character of length 1). Name of the file that will be written for 
storing the output. If NULL, no file will be saved.}

\item{getKeywords}{This argument is ignored. In this version of the function 
MeSH terms and codes (i.e., keywords) are parsed by default.}

\item{encoding}{The encoding of an input/output connection can be specified by name 
(for example, "ASCII", or "UTF-8", in the same way as it would be given to the function 
base::iconv(). See iconv() help page for how to find out more about encodings that can be 
used on your platform. Here, we recommend using "UTF-8".}
}
\value{
Data frame including the following fields: `c("pmid", "doi", 
"title", "abstract", "year", "month", "day", "jabbrv", "journal", 
"keywords", "mesh", "lastname", "firstname", "address", "email")`.
}
\description{
Extract Publication Info from PubMed records and cast data into a 
data.frame where each row corresponds to a different author. It is possible to limit
data extraction to first authors or last authors only, or get information about 
all authors of each PubMed record.
}
\details{
The `table_articles_byAuth()` function is now obsolete. 
You should use the `epm_parse()` function instead.
Please, have a look at the manual or the vignette.
The `table_articles_byAuth()` function will be retired in 2026.
}
\examples{
# Note: a time limit can be set in order to kill the operation when/if 
# the NCBI/Entrez server becomes unresponsive.
setTimeLimit(elapsed = 4.9)
try({
  q0 <- 'Damiano Fantini[AU] AND "2018"[PDAT]'
  q1 <- easyPubMed::get_pubmed_ids(pubmed_query_string = q0)
  q2 <- fetch_pubmed_data(pubmed_id_list = q1)
  df <- table_articles_byAuth(q2, included_authors = 'first')
  df[, c('pmid', 'lastname', 'jabbrv', 'year', 'month', 'day')]
}, silent = TRUE)
setTimeLimit(elapsed = Inf)


}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini \email{damiano.fantini@gmail.com}
}
