% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external.R
\name{createBiocRef}
\alias{createBiocRef}
\title{Create reference citation for Bioconductor packages}
\usage{
createBiocRef(
  pkg,
  format = "ris",
  filename = NULL,
  overwrite = TRUE,
  verbose = FALSE,
  database = "auto"
)
}
\arguments{
\item{pkg}{Character vector of Bioconductor package names to process}

\item{format}{Output format: "ris", "bib", "bibtex", or "both" (default: "ris")}

\item{filename}{Output file path. If NULL, creates a default filename based on package name(s).
If no file extension is provided, one will be added based on the format.}

\item{overwrite}{Allow overwriting existing files (default: TRUE)}

\item{verbose}{Logical. If TRUE, prints detailed information about each step (default: FALSE)}

\item{database}{Repository to search: "auto" (default), "cran", or "bioconductor".
For Bioconductor packages, "bioconductor" is recommended.}
}
\value{
Invisible list of results with package information and formatted citations. Always writes to file.
}
\description{
Convenience function specifically for Bioconductor packages. Automatically
detects Bioconductor packages and retrieves metadata from Bioconductor repositories.
}
\examples{
\donttest{
# Generate citation for Bioconductor packages (requires BiocManager)
if (requireNamespace("BiocManager", quietly = TRUE)) {
  result <- createBiocRef("Biobase", filename = tempfile())

  # Generate citations for multiple Bioconductor packages
  bioc_packages <- c("Biobase", "limma", "edgeR")
  results <- createBiocRef(bioc_packages, format = "both", filename = tempfile()) # Omit filename

  # Write Bioconductor package citations to file (extension added automatically)
  createBiocRef("Biobase", filename = tempfile()) # Replace with e.g. "biobase_citation"

  # Verbose output for Bioconductor packages (writes to default file)
  createBiocRef("Biobase", verbose = TRUE, filename = tempfile()) # Omit filename = tempfile()

  # Force search in Bioconductor repository
  createBiocRef("Biobase", database = "bioconductor", verbose = TRUE,
  filename = tempfile()) # Omit filename = tempfile()
}
}
}
