% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limma.R
\name{dprocess_dgeList}
\alias{dprocess_dgeList}
\title{Filter Low-Expressed Genes and Normalize DGEList Data}
\usage{
dprocess_dgeList(x, group.column, min.count = 10)
}
\arguments{
\item{x}{A \code{DGEList} object containing raw count data.}

\item{group.column}{The name of the column in \code{x$samples} that contains the
grouping information for the samples.}

\item{min.count}{The minimum number of counts required for a gene to be
considered expressed. Genes with counts below this threshold in any group
will be filtered out. Defaults to 10.}
}
\value{
The function returns a \code{DGEList} object with low-expressed genes
filtered out and normalization factors calculated.
}
\description{
This function filters out low-expressed genes from a \code{DGEList} object and
normalizes the count data. It also provides diagnostic plots for raw and
filtered data.
}
