% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nem_plot.R
\name{nem_plot,mf-method}
\alias{nem_plot,mf-method}
\title{Visualizing the metabolic footprint of nematode communities (single factor)}
\usage{
\S4method{nem_plot}{mf}(object, kei = 1, ksi = 1)
}
\arguments{
\item{object}{A \code{\link{mf-class}} object.}

\item{kei}{Adjust the width of the diamond, default \code{kei = 1}.}

\item{ksi}{Adjust the length of the diamond, default \code{ksi = 1}.}
}
\value{
An \code{gg} or \code{ggplot} object.
}
\description{
The \code{\link{nem_plot}} function is generalized to the \code{\link{mf-class}}
and is used to visualize the metabolic footprint of nematode communities. Metabolic
footprints quantify the amplitude of Carbon utilisation by different food web
components. The point in the middle of a rhombus represents the intersection
of EI and SI and length of vertical and horizontal axes of the rhombus corresponds
to the footprints of enrichment and structure components respectively.
}
\details{
To facilitate code interpretation, it is recommended to use the pipe symbol
\code{\link{|>}} to connect functions:

\if{html}{\out{<div class="sourceCode">}}\preformatted{nem_plot <- nem |> calc_nemindex() |> calc_mf(Treatments) |> nem_plot()
}\if{html}{\out{</div>}}
}
\examples{
nem <- read_nem2(tab = nemtab, tax = nemtax, meta = nemmeta)
nem_plot <- nem |>
            calc_nemindex() |>
            calc_mf(Treatments) |>
            nem_plot(kei = 30, ksi = 20)
nem_plot
}
\references{
\itemize{
\item \url{https://shiny.wur.nl/ninja/}
\item Ferris, Howard. "Form and function: metabolic footprints of nematodes in the
soil food web." European Journal of Soil Biology 46.2 (2010): 97-104.
}
}
\seealso{
The \code{nem_plot()} is used to visualize the calculation results and is a
generalized function for multiple classes including \code{\link{beta-class}},
\code{\link{beta2-class}}, \code{\link{compare-class}}, \code{\link{compare2-class}},
\code{\link{ef-class}}, \code{\link{ef2-class}}, \code{\link{funguild-class}},
\code{\link{funguild2-class}}, \code{\link{mf-class}}, \code{\link{mf2-class}},
\code{\link{ter-class}}, \code{\link{ter2-class}}, etc.
}
