% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/underwood_cbo.R
\name{Underwood_cbo}
\alias{Underwood_cbo}
\alias{Underwoodcbo}
\alias{underwoodcbo}
\title{Cost-Benefit Optimization after Underwood's equations}
\usage{
Underwood_cbo(
  comp.var,
  multSE = NULL,
  budget = NULL,
  a = NULL,
  ca = NULL,
  cm = NULL,
  cn
)
}
\arguments{
\item{comp.var}{Data frame as obtained from \code{\link[=scompvar]{scompvar()}}, containing variance
component estimates}

\item{multSE}{Optional. Numeric. Required multivariate standard error for the
sampling experiment.}

\item{budget}{Optional. Numeric. Total budget available for the sampling experiment.}

\item{a}{Numeric. Number of treatments to consider.}

\item{ca}{Numeric. Cost per treatment.}

\item{cm}{Numeric. Cost per replicate.}

\item{cn}{Numeric. Cost per sampling unit.}
}
\value{
A data frame containing the optimized values for \code{m} number of
sites to sample and \code{n} number of samples per site.
}
\description{
Applies a cost-benefit optimization model based on either a desired level of
precision or a predefined budget, following the approach of Underwood (1997).
}
\examples{
compVar <- scompvar(data = simResults)

# Optimization based on budget constraint
Underwood_cbo(comp.var = compVar, multSE = NULL, budget = 20000, a = 3, ca = 2500, cn = 100)

# Optimization based on precision constraint
Underwood_cbo(comp.var = compVar, multSE = 0.15, cn = 150)

}
\references{
\itemize{
\item Underwood, A. J. (1997). Experiments in ecology: their logical
design and interpretation using analysis of variance. Cambridge university
press.
\item Underwood, A. J., & Chapman, M. G. (2003). Power, precaution,
Type II error and sampling design in assessment of environmental impacts.
Journal of Experimental Marine Biology and Ecology, 296(1), 49-70.
}
}
\seealso{
\code{\link[=sim_beta]{sim_beta()}}
\code{\link[=plot_power]{plot_power()}}
\code{\link[=scompvar]{scompvar()}}
\code{\link[=sim_cbo]{sim_cbo()}}
}
\author{
Edlin Guerra-Castro (\email{edlinguerra@gmail.com}), Arturo Sanchez-Porras
}
