#' Abundance and body mass data to accompany the \code{Broadstone} data set
#'
#' Provides additional information about each macroinvertebrate taxon in the
#'   \code{\link{Broadstone}} food web for use alongside null model results in the
#'   foodweb package \code{cheddar} (Hudson \emph{et al}. 2013).
#'
#' @format A data frame with three columns and 19 rows:
#'   \describe{
#'     \item{node}{The name of the macroinvertebrate taxon (node) in the network}
#'     \item{M}{The mean body mass of an individual of the taxon, from
#'       \code{cheddar}'s \code{BroadstoneStream} object}
#'     \item{N}{The total abundance of each taxon from the 30 Surber samples (see
#'       \code{\link{Broadstone.prey}} for details)}
#'   }
#'
"Broadstone.nodes"
