% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tourism_region}
\alias{tourism_region}
\title{Tourism Regions and Nearest Weather Stations}
\format{
A data frame with `r nrow(tourism_region)` rows and 5 variables:
* **region**: Name of the tourism region. Tourism regions are defined by
  Tourism Research Australia and generally formed through the aggregation of
  Statistical Local Areas (SLAs) or other ABS-defined geographies.
* **lon**: Longitude of the tourism region representative point (WGS84).
* **lat**: Latitude of the tourism region representative point (WGS84).
* **region_id**: Unique integer identifier for the tourism region. Useful
  for joining with other tourism-related datasets.
* **ws_id**: Identifier of the nearest Bureau of Meteorology weather station
  to the tourism region.
}
\usage{
tourism_region
}
\description{
A dataset containing the locations of Australian tourism regions,
their geographic coordinates, and the nearest Bureau of Meteorology
weather station. Each region is assigned a unique identifier for
linking to other tourism datasets.
}
\details{
Coordinates for each tourism region are intended to represent a
central location within the region (e.g., polygon centroid). The
nearest weather station is determined using great-circle distance
calculations based on the Bureau of Meteorology's official station list.
}
\examples{
data(tourism_region)
head(tourism_region)
}
\references{
Tourism Research Australia: \url{https://www.tra.gov.au}
Australian Bureau of Meteorology: \url{http://www.bom.gov.au}
}
\keyword{datasets}
