% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectoryRMAPlot.R
\name{trajectoryRMAPlot}
\alias{trajectoryRMAPlot}
\title{Heat map-like plots for Relative Trajectory Movement Assessment (RTMA)}
\usage{
trajectoryRMAPlot(
  x,
  mode = "full",
  relationships.colors = NULL,
  traj.names = NULL,
  order.row = NULL,
  order.col = NULL,
  vertical = FALSE,
  legend = TRUE
)
}
\arguments{
\item{x}{An object of class \code{\link{RTMA}}.}

\item{mode}{The mode of trajectory relationship display (see details). Defaults to \code{"full"}, ignored if \code{relationships.colors} is specified.}

\item{relationships.colors}{Vector of user-chosen colors to represent trajectory relationships. Must have specific properties (see details). Overrides \code{mode}.}

\item{traj.names}{The names of trajectories. Defaults to the names provided in \code{x}.}

\item{order.row}{A re-ordering (and potential selection) of the rows of the output. If provided without \code{order.col}, the re-ordering is also applied to columns.}

\item{order.col}{If \code{order.row} is provided, this parameter allows to set a different order or selection for columns of the final display (allowing rectangular plots).}

\item{vertical}{Flag to indicate if the top trajectory names should be rotated 90°, defaults to \code{FALSE}.}

\item{legend}{Flag to indicate if the legend should be plotted, defaults to \code{TRUE}.}
}
\description{
Function \code{trajectoryRMAPlot} provides heat map-like plots for Relative Trajectory Movement Assessment (RTMA) performed by function \code{\link{trajectoryRMA}}.
}
\details{
Function \code{trajectoryRMAPlot} provides heat map-like plots for Relative Trajectory Movement Assessment (RTMA).
A key feature of the function is its different \code{mode} of representation, allowing to put more or less emphasis on some aspect of trajectories relative movements.
The 12 relative movement relationships recognized by RTMA may belong to three higher-order groups: the convergence group, the divergence group and the oriented group (see \code{\link{trajectoryRMA}} for more details).
The parameter \code{mode} allows to display targeted groups or combination of groups instead of the detailed relationships. Possible values for \code{mode} are:
\itemize{
\item{\code{"full"}: Default value. Display the finest level relationships.}
\item{\code{"convdiv"}: Displays and groups relationships belonging to the convergence and divergence groups.}
\item{\code{"oriented"}: Displays and groups relationships belonging to the oriented group.}
\item{\code{"crossed.groups"}: Displays and groups relationships belonging simultaneously to the oriented group and either the convergence or the divergence group.}
\item{\code{"convdiv.complete"}: As \code{"convdiv"} but adding in details the relationships that are neither from the convergence or divergence group.}
\item{\code{"oriented.complete"}: As \code{"oriented"} but adding in details the relationships that are not from the oriented group.}
\item{\code{"crossed.groups.complete"}: As \code{"crossed.groups"} but adding in details the relationships that do not belong to both the oriented group and either the convergence or divergence group.}
}
Relationships belonging to the oriented group are asymmetric. Practically, this means that one trajectory is in front while the other is in the back.
In the \code{trajectoryRMAPlot} output, crossed cells indicate that the corresponding ROW trajectory is the trajectory in front.

COLORS: Each \code{mode} comes with default colors for the heat map. Nonetheless, the parameter \code{relationships.colors} allows user-defined colors instead.
The vectors of colors provided in \code{relationships.colors} must have length 21 with \code{\link{names}} corresponding to the names of the different relationships recognized by RTMA
(can be found in a \code{\link{RTMA}} object \code{x} with \code{x$dynamic_relationships_taxonomy$dynamic_relationship}).
}
\examples{
#Prepare data
data("avoca")
avoca_D_man <- vegclust::vegdiststruct(avoca_strat, 
                                       method ="manhattan", 
                                       transform = function(x){log(x+1)})
years <- c(1971, 1974, 1978, 1983, 1987, 1993, 1999, 2004, 2009)
avoca_times <- years[avoca_surveys]
avoca_x <- defineTrajectories(d = avoca_D_man,  
                              sites = avoca_sites, 
                              times = avoca_times)
#Perform RTMA
avoca_RTMA <- trajectoryRMA(avoca_x)

#Default (full) output
trajectoryRMAPlot(avoca_RTMA)

#Play with different visualization modes of relationship groups
trajectoryRMAPlot(avoca_RTMA,mode="convdiv")
trajectoryRMAPlot(avoca_RTMA,mode="oriented")
trajectoryRMAPlot(avoca_RTMA,mode="crossed.groups")


}
\references{
Djeghri et al. (in preparation) Uncovering the relative movements of ecological trajectories.
}
\seealso{
\code{\link{trajectoryRMA}}, \code{\link{trajectoryConvergencePlot}}
}
\author{
Nicolas Djeghri, UBO

Miquel De \enc{Cáceres}{Caceres}, CREAF
}
