% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_all.R
\name{summ_by}
\alias{summ_by}
\title{Summarise continuous variables by group}
\usage{
summ_by(d, cols, ..., pct = c(0.25, 0.75), xname = "")
}
\arguments{
\item{d}{\verb{<dfr>} A data frame.}

\item{cols}{\verb{<var>} Optional. Columns to summarise as unquoted names.}

\item{...}{\verb{<var>} Optional. Columns to group by as unquoted names.}

\item{pct}{\verb{<num>} A vector of two indicating the percentiles to compute.}

\item{xname}{\verb{<chr>} Characters to omit in output column names.}
}
\value{
A data frame of summarised variables.
}
\description{
Summarise all continuous variables by group.
Non-numeric variables will be dropped.
}
\examples{
d = mtcars |> dplyr::mutate(vs=factor(vs), am=factor(am))
d |> summ_by()
d |> summ_by(pct=c(0.1,0.9))
d |> summ_by(mpg)
d |> summ_by(mpg,vs)
d |> summ_by(mpg,vs,am)
d |> summ_by(c(mpg,disp))
d |> summ_by(c(mpg,disp),vs)
d |> summ_by(c(mpg,disp),vs,xname="mpg_")
# Grouping without column selection is possible but rarely useful in large dataset
d |> summ_by(,vs)
}
