% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_all.R
\name{summ_cat}
\alias{summ_cat}
\title{Summarise categorical variables}
\usage{
summ_cat(d, ..., var)
}
\arguments{
\item{d}{A data frame.}

\item{...}{\verb{<var>} Optional. Columns to summarise.}

\item{var}{\verb{<var/int>} (name or index) Optional. A variable to extract as a data frame.}
}
\value{
A list containing summaries for all categorical variables or
a data frame showing the summary of a selected variable.
}
\description{
Summarise all categorical variables.
Numeric variables will be dropped.
}
\examples{
d = mtcars |> dplyr::mutate(dplyr::across(c(cyl,vs,am,gear,carb),factor))
d |> summ_cat()
d |> summ_cat(cyl,vs)
d |> summ_cat(var=cyl)
d |> summ_cat(var=1)
}
