% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{drug_use_tbl_df}
\alias{drug_use_tbl_df}
\title{Drug use of students and parents}
\format{
A tibble with 445 observations and 2 variables:
\describe{
  \item{student}{Whether the student has used drugs (factor with 2 levels).}
  \item{parents}{Whether the parent has used drugs (factor with 2 levels).}
}
}
\source{
The dataset was taken from the openintro package.
Ellis GJ and Stone LH. 1979. Marijuana Use in College: An Evaluation of a Modeling Explanation.
Youth and Society 10:323-334.
}
\usage{
data(drug_use_tbl_df)
}
\description{
This dataset, drug_use_tbl_df, is a tibble containing data on the drug use of students
and their parents. The dataset summarizes 445 student-parent pairs, with each pair indicating
whether the student and/or their parent has used drugs, specifically marijuana.
}
\details{
The dataset name has been kept as 'drug_use_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
educationR package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble. The original content has not been modified
in any way.
}
