% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_metrics.R
\name{eem_fluorescence_index}
\alias{eem_fluorescence_index}
\title{Calculate the fluorescence index (FI)}
\usage{
eem_fluorescence_index(eem, verbose = TRUE)
}
\arguments{
\item{eem}{An object of class \code{eemlist}.}

\item{verbose}{Logical determining if additional messages should be printed.}
}
\value{
An object of class \code{eemlist}.

A data frame containing fluorescence index (FI) for each eem.
}
\description{
Calculate the fluorescence index (FI)
}
\section{Interpolation}{


  Different excitation and emission wavelengths are often used to measure
  EEMs. Hence, it is possible to have mismatchs between measured wavelengths
  and wavelengths used to calculate specific metrics. In these
  circumstances, EEMs are interpolated using the
  \code{\link[pracma]{interp2}} function from the \code{parcma} library. A
  message warning the user will be prompted if data interpolation is
  performed.
}

\examples{
file <- system.file("extdata/cary/scans_day_1/", "sample1.csv", package = "eemR")
eem <- eem_read(file, import_function = "cary")

eem_fluorescence_index(eem)
}
\references{
\doi{https://doi.org/10.4319/lo.2001.46.1.0038}
}
\seealso{
\link[pracma]{interp2}
}
