% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provider-claude-files.R
\name{claude_file_upload}
\alias{claude_file_upload}
\alias{claude_file_list}
\alias{claude_file_get}
\alias{claude_file_download}
\alias{claude_file_delete}
\title{Upload, downloand, and manage files for Claude}
\usage{
claude_file_upload(
  path,
  base_url = "https://api.anthropic.com/v1/",
  beta_headers = "files-api-2025-04-14",
  credentials = NULL
)

claude_file_list(
  base_url = "https://api.anthropic.com/v1/",
  credentials = NULL,
  beta_headers = "files-api-2025-04-14"
)

claude_file_get(
  file_id,
  base_url = "https://api.anthropic.com/v1/",
  credentials = NULL,
  beta_headers = "files-api-2025-04-14"
)

claude_file_download(
  file_id,
  path,
  base_url = "https://api.anthropic.com/v1/",
  credentials = NULL,
  beta_headers = "files-api-2025-04-14"
)

claude_file_delete(
  file_id,
  base_url = "https://api.anthropic.com/v1/",
  credentials = NULL,
  beta_headers = "files-api-2025-04-14"
)
}
\arguments{
\item{path}{Path to download the file to.}

\item{base_url}{The base URL to the endpoint; the default is Claude's
public API.}

\item{beta_headers}{Beta headers to use for the request. Defaults to
\code{files-api-2025-04-14}.}

\item{credentials}{Override the default credentials. You generally should not need this argument; instead set the \code{ANTHROPIC_API_KEY} environment variable. The best place to set this is in \code{.Renviron},
which you can easily edit by calling \code{usethis::edit_r_environ()}.

If you do need additional control, this argument takes a zero-argument function that returns either a string (the API key), or a named list (added as additional headers to every request).}

\item{file_id}{ID of the file to get information about, download, or delete.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Use the beta Files API to upload files to and manage files in Claude.
This is currently experimental because the API is in beta and may change.
Note that you need \code{beta-headers = "files-api-2025-04-14"} to use the API.

Claude offers 100GB of file storage per organization, with each file
having a maximum size of 500MB. For more details see
\url{https://docs.claude.com/en/docs/build-with-claude/files}
\itemize{
\item \code{claude_file_upload()} uploads a file and returns an object that
you can use in chat.
\item \code{claude_file_list()} lists all uploaded files.
\item \code{claude_file_get()} returns an object for an previously uploaded file.
\item \code{claude_file_download()} downloads the file with the given ID. Note
that you can only download files created by skills or the code execution
tool.
\item \code{claude_file_delete()} deletes the file with the given ID.
}
}
\examples{
\dontrun{
file <- claude_file_upload("path/to/file.pdf")
chat <- chat_anthropic(beta_headers = "files-api-2025-04-14")
chat$chat("Please summarize the document.", file)
}
}
