% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variablesxperiodo.R
\name{variablesxperiodo}
\alias{variablesxperiodo}
\title{Identificar variables}
\usage{
variablesxperiodo(
  encuesta = "ENAHO",
  modulo,
  periodos,
  directorio = getwd(),
  tipo = "anual",
  ultimaetiqueta = TRUE,
  mostraretiqueta = FALSE
)
}
\arguments{
\item{encuesta}{el nombre de una encuesta del INEI. Las opciones dispobibles son
\code{"ENAHO"}, \code{"ENAHOpanel"} y \code{"ENDES"}. No importa si está escrito en mayúscula o minúscula.}

\item{modulo}{el código del módulo deseado.}

\item{periodos}{los años deseados.}

\item{directorio}{el directorio de donde están las carpetas generadas por \code{\link{descargar.inei}}.}

\item{tipo}{el tipo de período deseado. Las opciones son \code{"anual"},
  \code{"t1"} (primer trimestre),
  \code{"t2"} (segundo trimestre),
  \code{"t3"} (tercer trimestre),
y \code{"t4"} (cuarto trimestre). Las opciones pueden combinarse.}

\item{ultimaetiqueta}{un valor lógico que indica si debe usarse la última etiqueta.
Dado que la etiqueta de las variables puede cambiar con los años, se puede elegir qué etiqueta usar,
la del período más reciente que tiene esa variable  \code{ultimaetiqueta = TRUE} o del primer período
que tiene esa variable \code{ultimaetiqueta = FALSE}.}

\item{mostraretiqueta}{un valor lógico que indica si deben mostrarse las etiquetas.}
}
\value{
un data frame donde 1 significa que la variable está disponible y 0 que no está disponible.
}
\description{
Identifica las variables disponibles por periodo y tipo de bases de la ENAHO
descargadas con \code{\link{descargar.inei}}.
}
\examples{
directorio = system.file("extdata", package = "enaho")
variablesxperiodo(modulo = 37, periodos = 2011, directorio = directorio, tipo = c("t1","t2"))

}
