% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msf_dict.R
\name{msf_dict}
\alias{msf_dict}
\title{MSF data dictionaries and dummy datasets}
\usage{
msf_dict(dictionary, tibble = TRUE, long = TRUE, compact = TRUE)
}
\arguments{
\item{dictionary}{Specify which dictionary you would like to use.
\itemize{
\item MSF OCA outbreaks include: "AJS", "Cholera", "Measles", "Meningitis"
\item MSF intersectional outbreaks include: "AJS_intersectional", "Cholera_intersectional",
"Diphtheria_intersectional", "Measles_intersectional", "Meningitis_intersectional"
\item MSF OCA surveys include "Mortality", "Nutrition", "Vaccination_long",
"Vaccination_short" and "ebs"
}}

\item{tibble}{If \code{TRUE} (default), return data dictionary as a
tidyverse tibble otherwise will return a list.}

\item{long}{If \code{TRUE} (default), the returned data dictionary is in long
format with each option getting one row. If \code{FALSE}, then two data frames
are returned, one with variables and the other with content options.}

\item{compact}{If \code{TRUE} (default), then a nested data frame is returned
where each row represents a single variable and a nested data frame column
called "options", which can be expanded with \code{\link[tidyr:unnest]{tidyr::unnest()}}. This only
works if \code{long = TRUE}.}
}
\value{
A data frame (tibble) containing the specified MSF data dictionary.
If \code{long = TRUE}, each variable-option pair is represented as a row.
If \code{compact = TRUE}, the options are nested as a data frame column named
"options". If \code{long = FALSE}, a list is returned with two data frames:
\code{dictionary} and \code{options}.
}
\description{
These function produce MSF dictionaries based on DHIS2 (for OCA outbreaks)
and ODK (for intersectional outbreaks and surveys) data sets defining the
data element name, code, short names, types, and key/value pairs for
translating the codes into human-readable format.
}
\examples{

if (require("dplyr") & require("matchmaker")) {
  withAutoprint({
    # You will often want to use MSF dictionaries to translate codes to human-
    # readable variables. Here, we generate a data set of 20 cases:
    dat <- gen_data(
      dictionary = "Cholera",
      varnames = "data_element_shortname",
      numcases = 20,
      org = "MSF"
    )
    print(dat)

    # We want the expanded dictionary, so we will select `compact = FALSE`
    dict <- msf_dict(dictionary = "Cholera", long = TRUE, compact = FALSE, tibble = TRUE)
    print(dict)

    # Now we can use matchmaker to filter the data:
    dat_clean <- matchmaker::match_df(dat, dict,
      from = "option_code",
      to = "option_name",
      by = "data_element_shortname",
      order = "option_order_in_set"
    )
    print(dat_clean)
  })
}
}
\seealso{
\code{\link[=read_dict]{read_dict()}} \code{\link[=gen_data]{gen_data()}} \code{\link[matchmaker:match_df]{matchmaker::match_df()}}
}
