% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiparameter.R
\name{family.epiparameter}
\alias{family.epiparameter}
\title{Family method for the \verb{<epiparameter>} class}
\usage{
\method{family}{epiparameter}(object, ..., base_dist = FALSE)
}
\arguments{
\item{object}{An \verb{<epiparameter>} object.}

\item{...}{further arguments passed to methods.}

\item{base_dist}{A boolean \code{logical} for whether to return the name of a
transformed distribution (e.g. \code{"mixture"} or \code{"truncated"}) or the
underlying distribution type (e.g. \code{"gamma"} or \code{"lnorm"}). Default is
\code{FALSE}.}
}
\value{
A character string with the name of the distribution, or \code{NA} when
the \verb{<epiparameter>} object is unparameterised.
}
\description{
The \code{\link[=family]{family()}} function is used to extract the distribution
names from objects from \code{{distributional}} and \code{{distcrete}}. This method
provides the same interface for \verb{<epiparameter>} objects to give consistent
output irrespective of the internal distribution class.
}
\examples{
# example with continuous distribution
ep <- epiparameter(
  disease = "ebola",
  epi_name = "incubation_period",
  prob_distribution = create_prob_distribution(
    prob_distribution = "gamma",
    prob_distribution_params = c(shape = 1, scale = 1)
  )
)
family(ep)

# example with discretised distribution
ep <- epiparameter(
  disease = "ebola",
  epi_name = "incubation_period",
  prob_distribution = create_prob_distribution(
    prob_distribution = "lnorm",
    prob_distribution_params = c(meanlog = 1, sdlog = 1),
    discretise = TRUE
  )
)
family(ep)
}
