% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_mathjax.R
\name{transform_mathjax}
\alias{transform_mathjax}
\title{'MathJax' equation as 'HTML' or 'MathML'.}
\usage{
transform_mathjax(x, to = "html", display = FALSE, strict = "ignore")
}
\arguments{
\item{x}{MathJax equations}

\item{to}{output format, one of 'html' or 'mml'}

\item{display}{should the equation be in display (\code{TRUE}) or inline mode
(\code{FALSE}, by default)}

\item{strict}{KaTeX option.If \code{"ignore"} (default), allow features that make
writing LaTeX convenient. Other options are \code{"warn"} or \code{"error"}. This
happens E;G;, when you use accented characters in your equations.}
}
\value{
a character vector that contains 'html' or 'mml'
codes corresponding to the equations.
}
\description{
Get 'HTML' or 'MathML' XML codes corresponding to the rendering
of 'MathJax' equations.
}
\examples{
x <- c("(ax^2 + bx + c = 0)",
       "x = {-b \\\\pm \\\\sqrt{b^2-4ac} \\\\over 2a}.")
z <- transform_mathjax(x = x, to = "html")
cat(z, sep = "\n\n")
z <- transform_mathjax(x = x, to = "mml")
cat(z, sep = "\n\n")
}
