% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eratosthenes.R
\name{quae_postea}
\alias{quae_postea}
\alias{quae_postea.list}
\title{Quae Postea}
\usage{
quae_postea(obj)

\method{quae_postea}{list}(obj)
}
\arguments{
\item{obj}{A \code{list} of \code{vector} objects which reperesent ordered sequences.}
}
\value{
A \code{list} of \code{vector} objects, which contain the elements that occur after any one given element in the input sequences.
}
\description{
For a \code{list} of multiple partial sequences (of \code{vector} objects), generate another \code{list} which, for each element, gives all elements that occur after it ("\emph{quae postea}"). This is analogous to a recursive trace through all partial sequences from left to right. A final element \code{"omega"} is added to all sets to avoid empty vectors. See also \code{\link[eratosthenes]{quae_antea}}.
}
\examples{
x <- c("A", "B", "C")
y <- c("B", "D", "E", "C", "F")
z <- c("C", "G")
a <- list(x, y, z)

quae_postea(a)

}
