% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/induced_submat.R
\name{induced_submat}
\alias{induced_submat}
\title{Extract a submatrix from a network}
\usage{
induced_submat(x, v, ...)
}
\arguments{
\item{x}{Either a list or single matrices or network objects.}

\item{v}{Either a list or a single integer vector of vertices to subset.}

\item{...}{Currently ignored.}
}
\value{
A list of matrices as a result of the subsetting.
}
\description{
This is similar to \link[network:get.inducedSubgraph]{network::get.inducedSubgraph}. The main difference is that
the resulting object will always be a list of matrices, and it is vectorized.
}
\details{
Depending on the lengths of \code{x} and \code{v}, the function can take the
following strategies:
\itemize{
\item If both are of the same size, then it will match the networks and the vector
of indices.
\item If \code{length(x) == 1}, then it will use that single network as a baseline
for generating the subgraphs.
\item If \code{length(v) == 1}, then it will generate the subgraph using the same set
of vertices for each network.
\item If both have more than one element, but different sizes, then the function
returns with an error.
}
}
\examples{
x <- rbernoulli(100)
induced_submat(x, c(1, 10, 30:50))

x <- rbernoulli(c(20, 20))
induced_submat(x, c(1:10))

}
