% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialr_nbg_selector.R
\name{get_trialr_nbg_tite}
\alias{get_trialr_nbg_tite}
\title{Get an object to fit a TITE version of the NBG dose-finding model using trialr}
\usage{
get_trialr_nbg_tite(
  parent_selector_factory = NULL,
  real_doses,
  d_star,
  target,
  alpha_mean,
  alpha_sd,
  beta_mean,
  beta_sd,
  ...
)
}
\arguments{
\item{parent_selector_factory}{optional object of type
\code{\link{selector_factory}} that is in charge of dose selection before
this class gets involved. Leave as NULL to just use this model from the start.}

\item{real_doses}{Doses under investigation, a non-decreasing vector of
numbers.}

\item{d_star}{Numeric, reference dose for calculating the covariate
\code{log(dose / d_star)} when fitting the model. Sometimes (but not always)
taken to be the max dose in real_doses.}

\item{target}{We seek a dose with this probability of toxicity.}

\item{alpha_mean}{Prior mean of intercept variable for normal prior.
See Details. Also see documentation for trialr package for further details.}

\item{alpha_sd}{Prior standard deviation of intercept variable for normal prior.
See Details. Also see documentation for trialr package for further details.}

\item{beta_mean}{Prior mean of gradient variable for normal prior.
See Details. Also see documentation for trialr package for further details.}

\item{beta_sd}{Prior standard deviation of slope variable for normal prior.
See Details. Also see documentation for trialr package for further details.}

\item{...}{Extra args are passed to \code{\link[trialr]{stan_nbg}}.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit the
NBG model to outcomes.
}
\description{
Get an object to fit a TITE version of the NBG dose-finding model using trialr
}
\examples{
# TODO
}
