% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_getxml.R
\name{aux_getxml}
\alias{aux_getxml}
\title{Download and/or read station XML file}
\usage{
aux_getxml(
  xml,
  start,
  duration,
  network,
  station,
  component,
  url,
  level = "response"
)
}
\arguments{
\item{xml}{\code{Character} value, local XML file to import. If omitted,
the function expects information for the other arguments listed below to
download (into a temporary directory) and read the station XML file. In 
case both, the below information and a XML path is provided, the downloaded
data will be saved under the provided XML file name.}

\item{start}{\code{POSIXct} value, start time for which the XML 
information shall be collected. If omitted, XML information for all 
available time spans will be downloaded.}

\item{duration}{\code{Numeric} value, duration until when the XML 
information shall be collected. If omitted, XML information for all 
available time spans will be downloaded.}

\item{network}{\code{Character} value, seismic network to which the station
belongs, for which the XML data will be downloaded.}

\item{station}{\code{Character} value, seismic station ID for which the 
XML data will be downloaded. If omitted, XML information for all stations
of the network will be collected.}

\item{component}{\code{Character} value, component for which the XML data
will be downloaded. If omitted, XML data will be collected for all 
components available for the specified stations.}

\item{url}{\code{Chracter} vector, URL of the FDSN data provider. Should be 
of the form \code{"http://service.iris.edu"}, i.e., without further URL 
parts. URLs can be submitted as a vector.}

\item{level}{\code{Character} value, level of station XML information 
depth. Default is \code{"response"}.}
}
\value{
\code{Obspy} object with station meta info inventory.
}
\description{
This function either downloads an online station XML file and (optionally) 
saves it and/or reads an already existing local station XML file.
}
\details{
Currently, the function uses Obspy python code. Hence, both python and the 
package 'obspy' need to be installed in order to use the function.
}
\examples{

\dontrun{

x <- aux_getxml(start = "2010-10-10", 
                duration = 60,
                network = "GE",
                station = "BRNL",
                component = "BHZ",
                url = "http://service.iris.edu")

}

}
\author{
Michael Dietze
}
\keyword{eseis}
