% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_forest.R
\name{plot_forest}
\alias{plot_forest}
\title{Draw a forest plot using forestploter with publication-quality styling}
\usage{
plot_forest(
  data,
  estimate_col = "estimate",
  lower_col = "conf.low",
  upper_col = "conf.high",
  label_col = "variable",
  p_col = "p.value",
  ref_line = 1,
  sig_level = 0.05,
  bold_sig = TRUE,
  arrow_lab = c("Unfavorable", "Favorable"),
  ticks_at = c(0.5, 1, 1.5, 2),
  xlim = c(0, 3),
  footnote = "P-value < 0.05 was considered statistically significant",
  boxcolor = c("#E64B35", "#4DBBD5", "#00A087", "#3C5488", "#F39B7F", "#8491B4",
    "#91D1C2", "#DC0000", "#7E6148"),
  align_left = 1,
  align_right = NULL,
  align_center = NULL,
  gap_width = 30
)
}
\arguments{
\item{data}{Data frame with required columns: estimate, lower, upper, label, and p-value.}

\item{estimate_col}{Name of column containing point estimates.}

\item{lower_col}{Name of column containing lower CI.}

\item{upper_col}{Name of column containing upper CI.}

\item{label_col}{Name of column for variable labels.}

\item{p_col}{Name of column for p-values.}

\item{ref_line}{Reference line value, typically 1 for OR/HR.}

\item{sig_level}{Threshold to bold significant rows (default 0.05).}

\item{bold_sig}{Whether to bold significant rows.}

\item{arrow_lab}{Labels at both ends of the forest axis.}

\item{ticks_at}{Vector of x-axis tick marks.}

\item{xlim}{Range of x-axis (e.g., c(0, 3)). If NULL, auto-calculated. Default: c(0, 3).}

\item{footnote}{Caption text below the plot.}

\item{boxcolor}{Fill colors for CI boxes, will repeat if too short.}

\item{align_left}{Integer column indices to left-align.}

\item{align_right}{Integer column indices to right-align.}

\item{align_center}{Integer column indices to center-align.}

\item{gap_width}{Number of spaces in the gap column (default = 30).}
}
\value{
A forestplot object
}
\description{
Draw a forest plot using forestploter with publication-quality styling
}
