% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/responsdiffBeta.R
\name{responsediffBeta}
\alias{responsediffBeta}
\title{Calculate response differences along a set of selection gradients}
\usage{
responsediffBeta(G1, G2, Beta, means1 = 1, means2 = 1)
}
\arguments{
\item{G1}{A variance matrix.}

\item{G2}{A variance matrix.}

\item{Beta}{Either a vector or a matrix of unit length selection gradients
stacked column wise.}

\item{means1}{An optional vector of trait means of G1 (for internal mean
standardization).}

\item{means2}{An optional vector of trait means of G2 (for internal mean
standardization).}
}
\value{
An object of \code{class} \code{'responsdiffBeta'}, which is a list
with the following components:
\tabular{llllll}{
\code{Beta} \tab\tab\tab\tab The matrix of selection gradients. \cr
\code{d} \tab\tab\tab\tab The response difference of each selection gradient.
}
}
\description{
\code{G1} and \code{G2} need to be symmetric and positive definite.
}
\details{
\code{responsdiffBeta} calculates the response difference along selection 
gradients between two additive-genetic variance matrices as described in 
Hansen and Houle (2008).
}
\examples{
G1 <- matrix(c(1, 1, 0, 1, 2, 2, 0, 2, 3), ncol = 3) / 10
G2 <- matrix(c(1, 2, 0,2, 1, 1,0, 1, 3), ncol = 3)
Beta <- randomBeta(5, 3)
X <- responsediffBeta(G1, G2, Beta)
summary(X)
}
\references{
Hansen, T. F. & Houle, D. (2008) Measuring and comparing
evolvability and constraint in multivariate characters. J. Evol. Biol.
21:1201-1219.
}
\author{
Geir H. Bolstad
}
\keyword{algebra}
\keyword{array}
