% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_psychotools.R
\name{mloef.psy}
\alias{mloef.psy}
\title{Martin-Loef test for psychotools}
\usage{
mloef.psy(model, modelType, splitcr = "median", splitseed = NULL)
}
\arguments{
\item{model}{an object of 'psychotools' class 'raschmodel', 'pcmodel' or
'rsmodel'  (a model previously fit using the 'psychotools' package)
 matching the value of modelType.}

\item{modelType}{a character value defining the type of Rasch model.
Possible values: "RM", "PCM", "RSM"}

\item{splitcr}{Split criterion to define the item groups. "median" and
"mean" split items in two groups based on their items' raw scores median
or mean. "random" performs a random split (in this case, the seed can be
set with the "splitseed" argument. splitcr can also be a vector of length
k (where k denotes the number of items) that takes two or more distinct
values to define groups used for the Martin-Löf Test.}

\item{splitseed}{seed for random split}
}
\value{
a list containing the test statistic, the degrees of freedom and
 the p-value of the Martin-Löf test.
}
\description{
Martin-Loef test for psychotools
}
\examples{
 model <- psychotools::raschmodel(ADL[c(6,7,12,14,15)])
 mloef.psy(model=model, modelType="RM", splitcr="random", splitseed=332)
}
