% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{predict_target}
\alias{predict_target}
\title{Predict target using a trained model.}
\usage{
predict_target(data, model, name = "prediction")
}
\arguments{
\item{data}{A dataset (data.frame or tbl)}

\item{model}{A model created with \verb{explain_*()} function}

\item{name}{Prefix of variable-name for prediction}
}
\value{
data containing predicted probabilities for target values
}
\description{
Predict target using a trained model.
}
\examples{
\dontshow{if (rlang::is_installed(c("rpart", "randomForest", "xgboost"))) withAutoprint(\{ # examplesIf}
data_train <- create_data_buy(seed = 1)
data_test <- create_data_buy(seed = 2)
model <- explain_tree(data_train, target = buy, out = "model")
data <- predict_target(data = data_test, model = model)
describe(data)
\dontshow{\}) # examplesIf}
}
