% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AOI_seq.R
\name{AOI_seq}
\alias{AOI_seq}
\title{Sequence analysis of area of interest entries}
\usage{
AOI_seq(data, AOIs, AOI_names = NULL, progress = TRUE)
}
\arguments{
\item{data}{A dataframe with fixation data (from fixation_dispersion). Either single or multi participant data}

\item{AOIs}{A dataframe of areas of interest (AOIs), with one row per AOI (x, y, width_radius, height).}

\item{AOI_names}{An optional vector of AOI names to replace the default "AOI_1", "AOI_2", etc.}

\item{progress}{Display a progress bar}
}
\value{
a dataframe containing the sequence of entries into AOIs on each trial, entry/exit/duration time into AOI
}
\description{
Analyses the sequence of entries into defined AOI regions across trials. Can only be used with fixation data with a "fix_n" column denoting fixation events.
Assumes that AOIs are non-overlapping and hasn't been tested with overlapping AOIs. Consecutive fixations within an AOI are grouped together as a single entry.
Non-consecutive fixations in the same AOI (i.e., with an intervening fixation in no AOI) are treated as two separate entries.
}
\examples{
\donttest{
data <- combine_eyes(HCL)
fix_d <- fixation_dispersion(data)

AOI_seq(fix_d, AOIs = HCL_AOIs)
}

}
