% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoother.R
\name{smoother}
\alias{smoother}
\title{Smoothing of raw data}
\usage{
smoother(data, span = 0.05, plot = FALSE)
}
\arguments{
\item{data}{A dataframe with raw data (time, x, y, trial) for one participant}

\item{span}{From stats::loess. The parameter alpha which controls the degree of smoothing.}

\item{plot}{whether to plot the raw and smoothed plot for inspection}
}
\value{
a dataframe of the same shape as the input data
}
\description{
A wrapper for the stats::loess function, with default parameters suitable for smoothing raw eye data
}
\details{
Analyses data separately for each unique combination of values in \code{pID} and \code{trial}.
}
\examples{
data <- combine_eyes(HCL)

smoother(data)

#with an inspection plot
smoother(data, span = .02, plot = TRUE)

}
