% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var.R
\name{fitted.VAR}
\alias{fitted.VAR}
\title{Extract fitted values from a fable model}
\usage{
\method{fitted}{VAR}(object, ...)
}
\arguments{
\item{object}{A model for which forecasts are required.}

\item{...}{Other arguments passed to methods}
}
\value{
A vector of fitted values.
}
\description{
Extracts the fitted values.
}
\examples{
lung_deaths <- cbind(mdeaths, fdeaths) \%>\%
  as_tsibble(pivot_longer = FALSE)

lung_deaths \%>\%
  model(VAR(vars(mdeaths, fdeaths) ~ AR(3))) \%>\%
  fitted()
}
