% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srh.kway.full.R
\name{srh.kway.full}
\alias{srh.kway.full}
\title{Full pipeline: rank-based k-way ANOVA + descriptives + post hocs}
\usage{
srh.kway.full(formula, data, max_levels = 30)
}
\arguments{
\item{formula}{A formula \code{y ~ A (+ B + ...)}.}

\item{data}{A \code{data.frame} with variables present in \code{formula}.}

\item{max_levels}{Safety cap for number of levels per factor (default 30).}
}
\value{
A list with elements:
\itemize{
\item \code{anova} – ANOVA-like table,
\item \code{summary} – descriptive stats data.frame,
\item \code{posthoc_cells} – list of p.adj matrices for all effects
(from \code{srh.posthocs}), or a string when failed,
\item \code{posthoc_simple} – list of simple-effect tables
(from \code{srh.simple.posthocs}); for 1 factor: \code{"[not applicable]"},
\item \code{meta} – list with call, n, factor levels, and empty-cell info (if 2+ factors).
}
Components that cannot be computed for the given design are returned as the
string \code{"[not applicable]"}; failures are reported as \code{"[failed] <message>"}.
}
\description{
Runs a complete nonparametric, rank-based workflow for factorial designs:
(1) SRH-style ANOVA table, (2) compact descriptive stats with global ranks,
(3) Dunn-Bonferroni post hoc matrices for all effects, and
(4) simple-effects post hocs (Bonferroni within each by-table).
}
\details{
Choice of the ANOVA engine:
\itemize{
\item 1 factor: \code{srh.kway()} (KW-like),
\item 2 factors: \code{srh.effsize()} (SRH 2-way + effect sizes),
\item 3+ factors: \code{srh.kway()} (general k-way on ranks).
}
}
\examples{
data(mimicry, package = "factorH")
# 1 factor
f1 <- srh.kway.full(liking ~ condition, data = mimicry)
# 2 factors
f2 <- srh.kway.full(liking ~ gender + condition, data = mimicry)
# 3 factors
f3 <- srh.kway.full(liking ~ gender + condition + age_cat, data = mimicry)

}
