% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{NFL2007}
\alias{NFL2007}
\title{NFL 2007 season}
\format{
A data frame with 267 observations on the following 7 variables.
\describe{ 
\item{date}{ date on which game was played}
\item{visitor}{ visiting team} 
\item{visitorScore}{ score for visiting team} 
\item{home}{ home team} 
\item{homeScore}{ score for home team} 
\item{line}{ `betting line'}
\item{totalLine}{ 'over/under' line (for combined score of both teams)} }
}
\description{
Results of National Football League games (2007 season, including playoffs)
}
\examples{

data(NFL2007) 
NFL <- NFL2007 
NFL$dscore <- NFL$homeScore - NFL$visitorScore 
w <- which(NFL$dscore > 0) 
NFL$winner <- NFL$visitor; NFL$winner[w] <- NFL$home[w] 
NFL$loser <- NFL$home; NFL$loser[w] <- NFL$visitor[w] 
# did the home team win? 
NFL$homeTeamWon <- NFL$dscore > 0 
table(NFL$homeTeamWon)
table(NFL$dscore > NFL$line)

}
\keyword{datasets}
