% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{plot_did_dynamics}
\alias{plot_did_dynamics}
\title{Plot event study}
\usage{
plot_did_dynamics(x, margin = "event_time")
}
\arguments{
\item{x}{A data table generated with [fastdid] with one-dimensional index.}

\item{margin}{character, the x-axis of the plot}
}
\value{
A ggplot2 object
}
\description{
Plot event study results.
}
\examples{

# simulated data
simdt <- sim_did(1e+02, 10, seed = 1)
dt <- simdt$dt

# estimation
result <- fastdid(
  data = dt, timevar = "time", cohortvar = "G",
  unitvar = "unit", outcomevar = "y",
  result_type = "dynamic"
)

# plot
plot_did_dynamics(result)

}
