% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaults_registry.R
\name{validate_defaults_registry}
\alias{validate_defaults_registry}
\title{Validate Defaults Registry Against Parsnip}
\usage{
validate_defaults_registry()
}
\value{
A list of mismatches. Each element is a list with components:
  \describe{
    \item{algorithm}{The algorithm name.}
    \item{fastml_default}{The default engine recorded in fastml's registry.}
    \item{parsnip_default}{The actual default engine from parsnip.}
  }
  Returns an empty list if no mismatches are found.
}
\description{
Compares the hardcoded parsnip default engines in fastml's registry against
the actual defaults reported by \code{parsnip::show_engines()}. Returns a
list of any mismatches found, which may indicate that parsnip has updated
its defaults since fastml's registry was last updated.
}
\details{
This function queries parsnip for model specifications and compares
  against the hardcoded \code{parsnip_defaults} list in
  \code{get_parsnip_default_engine()}. Mismatches may occur when:
  \itemize{
    \item Parsnip updates its default engine for a model type
    \item New engines are added to parsnip that become the new default
    \item fastml's registry has not been updated after a parsnip release
  }

  This validation is intended for package maintenance and testing purposes.
}
\examples{
\dontrun{
mismatches <- validate_defaults_registry()
if (length(mismatches) > 0) {
  message("Found ", length(mismatches), " mismatch(es) with parsnip defaults")
}
}
}
