% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasts.R
\name{contr_code_poly}
\alias{contr_code_poly}
\title{Polynomial code a factor}
\usage{
contr_code_poly(fct, levels = NULL, colnames = NULL)
}
\arguments{
\item{fct}{the factor to contrast code (or a vector)}

\item{levels}{the levels of the factor in order}

\item{colnames}{optional list of column names for the added contrasts}
}
\value{
the factor with contrasts set
}
\description{
Polynomial coding sets the grand mean as the intercept. 
Each contrast tests a trend (linear, quadratic, cubic, etc.). This is only suitable for ordered factors.
}
\examples{
df <- sim_design(within = list(time = 1:6), 
                 mu = 1:6 + (1:6-3.5)^2, 
                 long = TRUE, plot = FALSE)
                 
df$time <- contr_code_poly(df$time)
lm(y ~ time, df) \%>\% broom::tidy()

}
