% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution_convertors.R
\name{norm2norm}
\alias{norm2norm}
\title{Convert normal to normal}
\usage{
norm2norm(x, mu = 0, sd = 1, x_mu = mean(x), x_sd = stats::sd(x))
}
\arguments{
\item{x}{the uniformly distributed vector}

\item{mu}{the mean of the normal distribution to return}

\item{sd}{the SD of the normal distribution to return}

\item{x_mu}{the mean of x (calculated from x if not given)}

\item{x_sd}{the SD of x (calculated from x if not given)}
}
\value{
a vector with a gaussian distribution
}
\description{
Convert a normal distribution to a normal (gaussian) distribution with specified mu and sd
}
\examples{

x <- rnorm(10000)
y <- norm2norm(x, 100, 10)
g <- ggplot2::ggplot() + ggplot2::geom_point(ggplot2::aes(x, y))
ggExtra::ggMarginal(g, type = "histogram")

}
